Attribute VB_Name = "CtrlCard"
'********************** Motion control module ********************

    'For a simple, convenient and fast to develop a common good, scalable,
     
    'Easy maintenance of applications, we have the basis for control of the library card will
     
    'All library functions are classified package. The following example uses a motion
     
    'Control card

'************************************************* *******
Public Result As Integer 'return value

Public gCardIndex As Long 'card

Const MAXAXIS = 6 'maximum number of axes

'******************* Initialization function ************************

    'This function contains a control card used in the library initialization function, which is called
     
    'The basis for other functions, it must first call in the example program
     
    'Return value <= 0 initialization failed, the return value> 0 indicates a successful initialization

'************************************************* ****
Public Function Init_Card() As Integer
        
    Result = adt8960_initial 'card initialization
     
    If Result <= 0 Then
      
       Init_Card = Result
        
       Exit Function
        
    End If
     
    For i = 1 To MAXAXIS
        
       adt8960_set_command_pos gCardIndex, i, 0 'logical position counter is cleared
        
       adt8960_set_actual_pos gCardIndex, i, 0 'real position counter clear bit
        
       adt8960_set_startv gCardIndex, i, 1000 'set the initial speed
        
       adt8960_set_speed gCardIndex, i, 2000 'set the drive speed
        
       adt8960_set_acc gCardIndex, i, 625 'set acceleration
      
    Next i
     
    Init_Card = Result
        
End Function

'********************Get version information ************************
'
'This function is used to obtain library version
'
'Parameters: libver - library version number
'
'************************************************* ********
Public Function Get_Version(libver As Double) As Single

     
   libver = adt8960_get_hardware_ver(gCardIndex)
     
End Function

'********************** Set speed module ***********************

'Based on value of the parameter to determine acceleration and deceleration is uniform or

'Set the initial speed of the shaft, drive speed and acceleration

'Parameters: axis - Axis No.

'StartV - initial velocity

'Speed - Drive speed

'Add - Acceleration
     
'Return value = 0 correct, an error return value = 1

'************************************************* ********
Public Function Setup_Speed(ByVal axis As Integer, ByVal startv As Long, ByVal speed As Long, ByVal add As Long, ByVal mode As Integer) As Integer

        If (startv - speed >= 0) Then 'set uniform
         
            Result = adt8960_set_startv(gCardIndex, axis, startv)
         
            adt8960_set_speed gCardIndex, axis, startv
                         
        Else
         
             Select Case mode
             
          Case 0 'trapezoidal acceleration and deceleration
            
             adt8960_set_ad_mode gCardIndex, axis, 0 'set to linear acceleration and deceleration mode
         
             Result = adt8960_set_startv(gCardIndex, axis, startv)
         
             adt8960_set_speed gCardIndex, axis, speed
          
             adt8960_set_acc gCardIndex, axis, add / 125
             
          Case 1 'S-type acceleration and deceleration
             
             Dim time As Double 'time is defined
                  
             Dim addvar As Double 'acceleration rate of change
                  
             Dim k As Long 'result to be calculated
                
             time = (speed - startv) / (add / 2) 'the acceleration time

             addvar = add / (time / 2) 'rate of change of acceleration

             k = 1000000 / addvar
              
             adt8960_set_ad_mode gCardIndex, axis, 1 'is set to 1: S curve acceleration and deceleration mode
              
             adt8960_set_startv gCardIndex, axis, startv / ratio
              
             adt8960_set_speed gCardIndex, axis, speed / ratio
         
             adt8960_set_acc gCardIndex, axis, add / 125 / ratio
         
             adt8960_set_acac gCardIndex, axis, k
              
         End Select
             
        End If
    
     
End Function

'********************* Axis drive functions **********************

    'This function is used to drive a single axis motion
     
    'Parameter: axis-axis number, pulse-output pulses
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******
Public Function Axis_Pmove(ByVal axis As Integer, ByVal pulse As Long) As Integer
     
    Result = adt8960_pmove(gCardIndex, axis, pulse)
     
    Axis_Pmove = Result
     
End Function
'************************ Uniaxial continuous drive function ******************** ***

'This function is used to drive a single axis motion

'Parameter: axis-axis number, value-pulse direction
     
'Return value = 0 correct, an error return value = 1

'************************************************* **********/
Public Function Axis_ConMove(ByVal axis As Integer, ByVal dir As Long) As Integer

    Result = adt8960_continue_move(gCardIndex, axis, dir)
     
    Axis_ConMove = Result
     
End Function

'******************* Any two axis interpolation function ********************

    'This function is used to drive any two axes interpolated motion
     
    'Parameters: axis1, axis2 - in the shaft No. interpolation
     
    'Pulse1, pulse2-axis corresponds to the number of output pulses
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******
Public Function Interp_Move2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long) As Integer

    Result = adt8960_inp_move2(gCardIndex, axis1, axis2, pulse1, pulse2)
     
    Interp_Move2 = Result
     
End Function

'*******************Any three-axis interpolation function ********************

    'This function is used to drive any axes motion interpolation
     
    'Parameters: axis1, axis2, axis3 - in the shaft No. interpolation
     
    'Pulse1, pulse2, pulse3-axis corresponds to the number of output pulses
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******

Public Function Interp_Move3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Integer

    Result = adt8960_inp_move3(gCardIndex, axis1, axis2, axis3, pulse1, pulse2, pulse3)
     
    Interp_Move3 = Result
     
End Function


'******************* Axis interpolation function ********************

    'This function is used to interpolate movement axis drive any
     
    'Parameters: axis1, axis2, axis3, axis4-in shaft No. interpolation
     
    'Pulse1, pulse2, pulse3, pulse4 - corresponding to the number of pulses output shaft
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******
Public Function Interp_Move4(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long) As Integer
     
    Result = adt8960_inp_move4(gCardIndex, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4)
     
    Interp_Move4 = Result
     
End Function


'******************* Five-axis interpolation function ********************

    'This function is used to interpolate axis movements drive any
     
    'Parameters: axis1, axis2, axis3, axis4, axis5-in shaft No. interpolation
     
    'Pulse1, pulse2, pulse3, pulse4, pulse5-axis corresponds to the number of output pulses
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******
Public Function Interp_Move5(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long) As Integer
     
    Result = adt8960_inp_move5(gCardIndex, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5)
     
    Interp_Move5 = Result
     
End Function


'******************* Six-axis interpolation function ********************

    'This function is used to drive the six-axis motion interpolation
     
    'Parameters:
     
    'Pulse1, pulse2, pulse3, pulse4, pulse5, pulse6-axis corresponds to the number of output pulses
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******
Public Function Interp_Move6(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long) As Integer
     
    Result = adt8960_inp_move6(gCardIndex, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6)
     
    Interp_Move6 = Result
     
End Function

'******************* Stop the driver function ********************

    'This function is used to stop driving, stop and slow down to stop immediately divided into
     
    'Parameter: axis-axis number, mode: 0 - stop, 1 - deceleration stop
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******
Public Function StopRun(ByVal axis As Integer, ByVal mode As Integer) As Integer

    If mode = 0 Then
         
        Result = adt8960_sudden_stop(gCardIndex, axis)
         
    Else
     
        Result = adt8960_dec_stop(gCardIndex, axis)
     
    End If
     
    StopRun = Result

End Function

'******************* Set the position function ********************

    'This function is used to set the logical position and actual position
     
    'Parameter: axis-axis No. setting pos-location
     
    'Mode
     
    '0 - set the logical location 1 - set the actual position
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******
Public Function Setup_Pos(ByVal axis As Integer, ByVal pos As Long, ByVal mode As Integer) As Integer

    If mode = 0 Then
     
        Result = adt8960_set_command_pos(gCardIndex, axis, pos)
         
    Else
     
        Result = adt8960_set_actual_pos(gCardIndex, axis, pos)
         
    End If
     
End Function

'******************* For sports information function ********************

    'The function used to obtain the logical location, the actual position and speed
     
    'Parameter: axis-axis number, logps-logical location
     
    'Actpos-actual position, speed-running speed
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******
Public Function Get_CurrentInf(ByVal axis As Integer, LogPos As Long, actpos As Long, speed As Long) As Integer

    Result = adt8960_get_command_pos(gCardIndex, axis, LogPos)
     
    adt8960_get_actual_pos gCardIndex, axis, actpos
     
    adt8960_get_speed gCardIndex, axis, speed
     
    Get_CurrentInf = Result
     
End Function


'*******************Get state of motion function ********************

    'This function is used to obtain the status of the drive shaft and the driving state of interpolation
     
    'Parameter: axis-axis number, value-state (0 - drive end, non-0 - is driving)
     
    'Mode 0 - for single-axis drive status, non-0 - for interpolation driving status
     
    'Return value = 0 correct, an error return value = 1

'************************************************* ******
Public Function Get_MoveStatus(ByVal axis As Integer, ByVal value As Integer, ByVal mode As Integer) As Integer

    If mode = 0 Then
     
        GetMove_Status = adt8960_get_status(gCardIndex, axis, value)
         
    Else
     
        GetMove_Status = adt8960_get_inp_status(gCardIndex, value)
         
    End If
     
End Function

'*********************** Read input ********************** *********
'
'This function is used to read a single entry point
'
'Argument: number-input (0 ~ 31)
'
'Returns: 0 - low, 1 - high, -1-- error
'
'************************************************* ***************
Public Function Read_Input(ByVal number As Integer) As Integer
     
    Read_Input = adt8960_read_bit(gCardIndex, number)
     
End Function

'********************* Output single point function ************************ ******
'
'This function is used to output a single point of signal
'
'Argument: number-output point (0 to 15)

'Value 0 - low 1 - high
'
'Return value = 0 correct, an error return value = 1
'************************************************* ***************
Public Function Write_Output(ByVal number As Integer, ByVal value As Integer) As Integer

    Write_Output = adt8960_write_bit(gCardIndex, number, value)
     
End Function


'******************** Set the pulse output mode **********************
'
'This function is used to set the pulse of the work
'
'Parameter: axis-axis number, value-pulse mode 0 - pulse + pulse 1 - Pulse + direction method
'
'Return value = 0 correct, an error return value = 1
'
'Default pulse mode for the pulse + direction
'
'This program uses the default positive logic pulse and direction output signals are logic
'
'************************************************* ********
Public Function Setup_PulseMode(ByVal axis As Integer, ByVal value As Integer) As Integer

    Setup_PulseMode = adt8960_set_pulse_mode(gCardIndex, axis, value, 0, 0)
     
End Function

'******************** Set limit signaling **********************
'
'This function is used to set the positive / negative direction limit input signal mode nLMT
'
'Parameters: axis - Axis No.
'Value1 0 - is the effective limit 1 - is the limit is not valid
'Value2 0 - negative limit effective 1 - negative limit is not valid
'Logic 0 - active LOW 1 - active HIGH
'Default mode is: is the effective limit the negative limit, active-low
'
'Return value = 0 correct, an error return value = 1
'************************************************* ********
Public Function Setup_LimitMode(ByVal axis As Integer, ByVal value1 As Integer, ByVal value2 As Integer, ByVal logic As Integer) As Integer

    Setup_LimitMode = adt8960_set_limit_mode(gCardIndex, axis, value1, value2, logic)
     
End Function

'
'******************** Set stop0 signaling **********************
'
'This function is used to set the signal mode stop0
'
'Parameters: axis - Axis No.

'Value 0 - invalid 1 - Effective

'Logic 0 - active LOW 1 - active HIGH
'Default mode: Invalid
'
'Return value = 0 correct, an error return value = 1
'************************************************* ********
Public Function Setup_Stop0Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop0Mode = adt8960_set_stop0_mode(gCardIndex, axis, value, logic)
     
End Function


'******************** Set stop1 signaling **********************
'
'This function is used to set the signal mode stop1
'
'Parameters: axis - Axis No.
'Value 0 - invalid 1 - Effective

'Logic 0 - active LOW 1 - active HIGH
'Default mode: Invalid
'
'Return value = 0 correct, an error return value = 1
'************************************************* ********
Public Function Setup_Stop1Mode(ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_Stop1Mode = adt8960_set_stop1_mode(gCardIndex, axis, value, logic)
     
End Function

'******************** Set the hardware to stop **************************
'
'This function is used to set the hardware stop mode
'
'Parameter: value 0 - invalid 1 - Effective

'Logic 0 - active LOW 1 - active HIGH

'Default mode: Invalid
'
'Return value = 0 correct, an error return value = 1

'Hardware terminal stop signal is fixed using the P3 board 34 pin (IN31)
'************************************************* ********

Public Function Setup_HardStop(ByVal value As Integer, ByVal logic As Integer) As Integer

    Setup_HardStop = adt8960_set_suddenstop_mode(gCardIndex, value, logic)
     
End Function

'******************** Set delay **************************
'
'This function is used to set the delay
'
'Parameters: time - delay time (in us)
'
'Return value = 0 correct, an error return value = 1

'************************************************* ********

Public Function Setup_Delay(ByVal time As Long) As Integer

    Setup_Delay = adt8960_set_delay_time(gCardIndex, time * 8)
     
End Function

'********************** For delay status **********************

'This function is used to obtain the status of delay

'Return value 0 - delay the end of 1 - Delay in progress

'************************************************* *******

Public Function Get_DelayStatus() As Integer

    Get_DelayStatus = adt8960_get_delay_status(gCardIndex)
     
End Function

'******************** set Universal input and output **********************

'This function is used to set the general-purpose input-output

'Parameters:
'V1 -0: 8 points in front of the input is defined as 1: 8 points in front of the output is defined as

'V2 -0: 8 points behind the input is defined as 1: 8 points behind is defined as the output

'Return value = 0 correct, an error return value = 1

'Note: When the IO point when used as outputs and can also read the input status
'************************************************* ********/
Public Function Set_IoMode(ByVal v1 As Integer, ByVal v2 As Integer) As Integer
     
    Set_IoMode = adt8960_set_io_mode(gCardIndex, v1, v2)

End Function


'/***************************** Axis relative motion *************** ******
'* Function: with reference to the current position, move to accelerate the quantitative
'* Parameters:
'Cardno - card number
'Axis --- axis No.
'Pulse - pulse
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Return value 0: the right 1: Error
'************************************************* ******************/
Public Function Sym_RelativeMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeMove = adt8960_symmetry_relative_move(gCardIndex, axis, pulse, lspd, hspd, tacc, vacc, mode)
     
End Function

'/*************************** Axis absolute Mobile ***************** *******
'* Function: zero reference position to accelerate the move to quantify
'* Parameters:
'Cardno - card number
'Axis --- axis No.
'Pulse - pulse
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Return value 0: the right 1: Error
'************************************************* *******************/
Public Function Sym_AbsoluteMove(ByVal axis As Integer, ByVal pulse As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteMove = adt8960_symmetry_absolute_move(gCardIndex, axis, pulse, lspd, hspd, tacc, vacc, mode)
     
End Function

'/********************** Relative movement of the two-axis linear interpolation ******************* *
'* Function: with reference to the current location to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Return value 0: the right 1: Error
'************************************************* *****************/
Public Function Sym_RelativeLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeLine2 = adt8960_symmetry_relative_line2(gCardIndex, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode)
     
End Function

'/******************** Absolute two-axis linear interpolation move ********************* *
'* Function: zero reference position to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'Return value 0: the right 1: Error
'************************************************* *****************/
Public Function Sym_AbsoluteLine2(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteLine2 = adt8960_symmetry_absolute_line2(gCardIndex, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode)
     
End Function


'/********************** Axis linear interpolation relative motion ******************* *
'* Function: with reference to the current location to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'
'Return value 0: the right 1: Error
'************************************************* *****************/
Public Function Sym_RelativeLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeLine3 = adt8960_symmetry_relative_line3(gCardIndex, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode)
     
End Function

'/********************* Absolute motion ******************** axis linear interpolation *
'Function: with reference to the zero position to accelerate in a straight line interpolation
'Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'
'Return value 0: the right 1: Error
'************************************************* *****************/
Public Function Sym_AbsoluteLine3(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteLine3 = adt8960_symmetry_absolute_line3(gCardIndex, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode)
     
End Function

'/***************** Axis linear interpolation relative motion ****************
'* Function: with reference to the current location to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Axis4 --- Shaft No. 4
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'************************************************* *****/
Public Function Sym_RelativeLine4(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeLine4 = adt8960_symmetry_relative_line4(gCardIndex, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc, vacc, mode)
     
End Function

'/***************** Absolute motion **************** axis linear interpolation
'* Function: with reference to the zero position, in order to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Axis4 --- Shaft No. 4
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'************************************************* *****/
Public Function Sym_AbsoluteLine4(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteLine4 = adt8960_symmetry_absolute_line4(gCardIndex, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc, vacc, mode)
     
End Function


'/***************** Axis linear interpolation relative motion ****************
'* Function: with reference to the current location to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Axis4 --- Shaft No. 4
'Axis5 --- No. 5 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Pulse5 - Pulse 5
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'************************************************* *****/
Public Function Sym_RelativeLine5(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_RelativeLine5 = adt8960_symmetry_relative_line5(gCardIndex, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5, lspd, hspd, tacc, vacc, mode)

End Function


'/***************** Axis linear interpolation absolute motion ****************
'* Function: zero reference position to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Axis1 --- Shaft No. 1
'Axis2 --- No. 2 shaft
'Axis3 --- No. 3 shaft
'Axis4 --- Shaft No. 4
'Axis5 --- No. 5 shaft
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Pulse5 - Pulse 5
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'************************************************* *****/
Public Function Sym_AbsoluteLine5(ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal axis4 As Integer, ByVal axis5 As Integer, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

    Sym_AbsoluteLine5 = adt8960_symmetry_absolute_line5(gCardIndex, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5, lspd, hspd, tacc, vacc, mode)
     
End Function



'/***************** Six-axis linear interpolation relative motion ****************
'* Function: with reference to the current location to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Pulse5 - Pulse 5
'Pulse6 - Pulse 6
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'************************************************* *****/
Public Function Sym_RelativeLine6(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

      Result = adt8960_symmetry_relative_line6(gCardIndex, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6, lspd, hspd, tacc, vacc, mode)
   
     Sym_RelativeLine6 = Result
      
End Function
  


'/***************** Six-axis linear interpolation absolute motion ****************
'* Function: zero reference position to speed up the linear interpolation
'* Parameters:
'Cardno - card number
'Pulse1 - Pulse 1
'Pulse2 - Pulse 2
'Pulse3 - Pulse 3
'Pulse4 - Pulse 4
'Pulse5 - Pulse 5
'Pulse6 - Pulse 6
'Lspd --- low
'Hspd --- High Speed
'Tacc --- acceleration time (unit: seconds)
'************************************************* *****/
Public Function Sym_AbsoluteLine6(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long, ByVal pulse5 As Long, ByVal pulse6 As Long, ByVal lspd As Long, ByVal hspd As Long, ByVal tacc As Double, ByVal vacc As Long, ByVal mode As Integer) As Integer

       Result = adt8960_symmetry_absolute_line6(gCardIndex, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6, lspd, hspd, tacc, vacc, mode)
  
        Sym_AbsoluteLine6 = Result
     
End Function


'/************************************************ *****
'Function: Get Output
'Parameters:
'Cardno card number
'Number Output
'Return value Returns: the current state of specified port, -1 means the parameter error
'************************************************* ****/
Public Function Get_OutNum(ByVal number As Integer) As Integer

    Result = adt8960_get_out(gCardIndex, number)
     
    Get_OutNum = Result
     
End Function

'********************Quantitative drive external signals ************************* **********************
'Function: function of the external signal quantitatively driven
'Parameters:
'Cardno card number
'Axis axis No.
'Pulse pulse
'Return value 0: the right 1: Error
'Note: (1) a quantitative pulse, but the driver does not immediately need to wait until the external signal level changes
'(2) You can use an ordinary button, you can also take over the wheel
'************************************************* *****************/
Public Function Manu_Pmove(ByVal axis As Integer, ByVal pulse As Long) As Integer

    Result = adt8960_manual_pmove(gCardIndex, axis, pulse)
     
    Manu_Pmove = Result
     
End Function

'************************ External signal continuous drive function ******************** **
'Functions: continuous drive function of external signals
'Parameters:
'Cardno card number
'Axis axis No.
'Return value 0: the right 1: Error
'Note: (1) a quantitative pulse, but the driver does not immediately need to wait until the external signal level changes
'(2) You can use an ordinary button, you can also take over the wheel
'************************************************* *****************/
Public Function Manu_Continue(ByVal axis As Integer) As Integer

    Result = adt8960_manual_continue(gCardIndex, axis)
     
    Manu_Continue = Result

End Function

'*********************** Off the external signal driver is enabled ******************** ***
'Function: turn off the external drive enable signal
'Parameters:
'Cardno card number
'Axis axis No.
'Return value 0: the right 1: Error
'************************************************* *****************/
Public Function Disable_Manu(ByVal axis As Integer) As Integer

   Result = adt8960_manual_disable(gCardIndex, axis)

   Disable_Manu = Result

End Function

'------------------------ --------------------- Position latch function -----
'Note: When the latch signal is triggered, the current location of the encoder is immediately captured. This function is used for position measurement is accurate, convenient.
'------------------------------------------------- ----------
'************************* Get latched state ******************** ***
'Function: Get the latch state
'Parameters:
'Cardno card number
'Axis axis No.
'Status-0 | latch state is not running
'1 | latch state executed
'Return value 0: the right 1: Error
'Note: Use this function to capture the position of whether to implement latch
'************************************************* *****************/
Public Function Get_LockStatus(ByVal axis As Integer, status As Integer) As Integer

    Result = adt8960_get_lock_status(gCardIndex, axis, status)
  
    Get_LockStatus = Result
     
End Function

'**************************** Position latch set function **************** ******
'Function: signaling functions set in place, lock all the axes and the actual location of the logical location
'Parameters:
'Axis-reference axis
'Mode-position latch mode | 0: Invalid
'| 1: Effective
'Regi-counter mode | 0: logical location
'| 1: actual position
'Logical-level signal | 0: high to low
'| 1: from low to high
'Return value 0: the right 1: Error
'Note: Use the specified axis axis of the IN signal as the trigger signal
'************************************************* ******************/
Public Function Setup_LockPosition(ByVal axis As Integer, ByVal mode As Integer, ByVal regi As Integer, ByVal logical As Integer) As Integer
     
    Result = adt8960_set_lock_position(gCardIndex, axis, mode, regi, logical)
     
    Setup_LockPosition = Result
     
End Function


'************************** Get locked position ******************* *******
'Function: Get the locked position
'Parameters:
'Cardno card number
'Axis axis No.
'Pos position latch
'Return value 0: the right 1: Error
'************************************************* *****************
Public Function Get_LockPosition(ByVal axis As Integer, pos As Long) As Integer

    Result = adt8960_get_lock_position(gCardIndex, axis, pos)
     
    Get_LockPosition = Result
     
End Function

'************************** Clear latched status ******************* *******
'Function: Clear latched status
'Parameters:
'Cardno card number
'Axis axis number (1 - 4)
'Return value 0: the right 1: Error
'************************************************* *****************
Public Function Clr_LockStatus(ByVal axis As Integer) As Integer

    Result = adt8960_clr_lock_status(gCardIndex, axis)
     
    Clr_LockStatus = Result
     
End Function

